/* ------------------------------------------------------------------------------
  File: chr6d_packet_handler.h
  Author: CH Robotics
  Version: 1.0
  
  Description: Definitions used for handling packets.
------------------------------------------------------------------------------ */ 
#ifndef __CHR6D_PACKET_HANDLER_H
#define __CHR6D_PACKET_HANDLER_H

#include "chr6d_usart.h"
#include "chr6d_FIR.h"
#include "chr6d_startup.h"

void ProcessPacket( USARTPacket* new_packet );

void SendCommandSuccessPacket( int command );
void SendCommandFailedPacket( int command, int flag );

void SendDataPacket( void );

void SendGyroBiasPacket( void );
void SendAccelBiasPacket( void );
void SendFIR_Packet( void );
void SendFIR_TapPacket( void );
void SendActiveChannelPacket( void );
void SendTransmitModePacket( void );
void SendStatusReportPacket( uint16_t result );

// Global data buffers defined in main.c

// Output of oversampler/decimator
extern short gDecimatedOutput[CHANNEL_COUNT];
// Intermediate buffer, stores result of oversampled, averaged data.  Used as input
// to FIR low-pass filter.
extern short gFIR_Input[CHANNEL_COUNT][MAX_INPUT_SIZE];
// Buffer to store data after all over-sampling, decimating, and filtering is performed.
extern short gFIR_Output[CHANNEL_COUNT];

#endif
